package com.agilex.healthcare.veteranappointment.datalayer.feedback;

import com.agilex.healthcare.veteranappointment.domain.VARFeedback;
import com.agilex.healthcare.veteranappointment.exception.InvalidUserFeedbackException;
import com.agilex.healthcare.veteranappointment.validator.ValidationError;
import com.agilex.healthcare.veteranappointment.validator.ValidationResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Service
public class UserFeedbackDataService {
	
	private static final String RECOMMENDATION_RATING_FIELD = "recommendationRating";
	private static final String ERROR = "error";

	@Resource
	UserFeedbackDataLayer userFeedbackDataLayer;
	
	public VARFeedback saveUserFeedback(VARFeedback userFeedback) {
		validateUserFeedback(userFeedback);
		userFeedback.setDateCreated(new Date());
		return userFeedbackDataLayer.saveUserFeedback(userFeedback);
	}

	private void validateUserFeedback(VARFeedback userFeedback) {
		ValidationResult<VARFeedback> validationResult = new ValidationResult<VARFeedback>();
		validationResult.setRequestObject(userFeedback);

		if(userFeedback == null){
			validationResult.addIfNotNull(createValidationError(ERROR, "UserFeedback object is empty"));
		}else{
			validateRecommendationRating(userFeedback, validationResult);
		}
		
		if (!validationResult.isValid()) {
			throw new InvalidUserFeedbackException(validationResult.getErrors());
		}
	}
	
	private void validateRecommendationRating(VARFeedback userFeedback, ValidationResult<VARFeedback> validationResult) {
		if(userFeedback.getRecommendationRating() == null){
			validationResult.addIfNotNull(createValidationError(RECOMMENDATION_RATING_FIELD, "Recommendation rating field is not set"));
		}
	}

	private ValidationError createValidationError(String field, String message){
		ValidationError error = new ValidationError();
		error.setErrorMessage(message);
		error.setFieldName(field);
		return error;
	}

}
